/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.betterx.bclib.recipes.AbstractSimpleRecipeBuilder;
import org.betterx.bclib.util.ItemUtil;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSingleInputRecipeBuilder<T extends AbstractSingleInputRecipeBuilder, R extends Recipe<? extends Container>>
extends AbstractSimpleRecipeBuilder<T> {
    protected final Advancement.Builder advancement = Advancement.Builder.m_138353_();

    protected AbstractSingleInputRecipeBuilder(ResourceLocation id, ItemLike output) {
        this(id, new ItemStack(output, 1));
    }

    protected AbstractSingleInputRecipeBuilder(ResourceLocation id, ItemStack output) {
        super(id, output);
    }

    @Override
    public T unlockedBy(ItemLike item) {
        return (T)((AbstractSingleInputRecipeBuilder)super.unlockedBy(item));
    }

    @Override
    public T unlockedBy(TagKey<Item> tag) {
        return (T)((AbstractSingleInputRecipeBuilder)super.unlockedBy(tag));
    }

    @Override
    protected T unlocks(String name, CriterionTriggerInstance trigger) {
        this.advancement.m_138386_(name, trigger);
        return (T)this;
    }

    @Override
    protected void buildRecipe(Consumer<FinishedRecipe> cc) {
        this.setupAdvancementForResult();
        cc.accept(new Result());
    }

    protected abstract RecipeSerializer<R> getSerializer();

    protected void serializeRecipeData(JsonObject root) {
        root.add("input", ItemUtil.toJsonIngredientWithNBT(this.primaryInput));
        if (this.group != null && !this.group.isEmpty()) {
            root.addProperty("group", this.group);
        }
        root.add("result", (JsonElement)ItemUtil.toJsonRecipeWithNBT(this.output));
    }

    protected void setupAdvancementForResult() {
        this.advancement.m_138396_(RecipeBuilder.f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)this.id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)this.id)).m_138360_(RequirementsStrategy.f_15979_);
    }

    protected ResourceLocation createAdvancementId() {
        return this.id.m_246208_("recipes/" + this.category.m_247710_() + "/");
    }

    public class Result
    implements FinishedRecipe {
        private final ResourceLocation advancementId;

        protected Result() {
            this.advancementId = AbstractSingleInputRecipeBuilder.this.createAdvancementId();
        }

        public ResourceLocation m_6445_() {
            return AbstractSingleInputRecipeBuilder.this.getId();
        }

        public RecipeSerializer<R> m_6637_() {
            return AbstractSingleInputRecipeBuilder.this.getSerializer();
        }

        @Nullable
        public JsonObject m_5860_() {
            return AbstractSingleInputRecipeBuilder.this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }

        public void m_7917_(JsonObject root) {
            AbstractSingleInputRecipeBuilder.this.serializeRecipeData(root);
        }
    }
}

